function ccWithSeed = getConnectedComponentsWithSeed(imgBW, seedMask)
%GETCONNECTEDCOMPONENTWITHSEED Gets connected components in a binary image
%that are reachable from input seed scribbles
%
%   Input:
%       imgBW   : binary image
%       seedMask: binary mask to represent input seed scribbles
% 
%   Output:
%       ccWithSeed: binary mask that represents the output connected
%       components
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.

    [scribblesConnComps, numScribblesComps] = bwlabel(seedMask);

    connCompsAll = bwlabel(imgBW);
    ccWithSeed = false(size(imgBW));

    for compID = 1 : numScribblesComps
        scribbleSampleIndex = find(scribblesConnComps == compID);
        scribbleSampleIndex(connCompsAll(scribbleSampleIndex) == 0) = [];
        assert(length(unique(connCompsAll(scribbleSampleIndex))) == 1);
        scribbleLabel = connCompsAll(scribbleSampleIndex(1));
        ccWithSeed(connCompsAll == scribbleLabel) = true;
    end

    ccWithSeed(seedMask) = true; % hard constraint
end

